<?php
use Elementor\Plugin as Elementor;
use Codexpert\CoDesigner_Pro\Helper;

// get the template ID from global var
$template_id        = codesigner_sanitize_number( $_REQUEST['template_id'] );
$html               = Elementor::$instance->frontend->get_builder_content( $template_id );
$pattern            = '/class="(.*?\s+)?elementor-col-(\d+)(\s+.*?)?"/i';

/**
 * for old email designer widgets user
 */
if ( ! codesigner_new_email_designer_active() ) {
    $html = preg_replace_callback( $pattern, function( $matches ) {
        $classNameBefore    = $matches[1] ?? '';
        $widthValue         = $matches[2];
        $classNameAfter     = $matches[3] ?? '';
    
        return 'class="' . $classNameBefore . 'elementor-col-' . $widthValue . $classNameAfter . '" style="width: ' . $widthValue . '%;float:left;"';
    }, $html );
}

if ( isset( $_POST['user_login'] ) ) {
    $link           = get_user_password_reset_url( $user_login );
    $html           = str_replace( '%%reset_password%%', $link, $html );
}

if ( isset( $_POST['billing_email'] ) ) {
    $link           = get_user_password_reset_url( $_POST['billing_email'] );
    $html           = str_replace( '%%set_password%%', $link, $html );
}

echo "<div id='wl-mail-container'>{$html}</div>";